/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_VARS_H
#define _UDM_VARS_H

extern void UdmVarListInit(UDM_VARLIST * vars);
extern void UdmVarListFree(UDM_VARLIST * vars);
extern int  UdmVarListEnter(UDM_VARLIST *vars);
extern int  UdmVarListLeave(UDM_VARLIST *vars);
extern void UdmVarFree(UDM_VAR *);

extern int UdmVarListAddStr(UDM_VARLIST * vars,const char * name, const char * val);
extern int UdmVarListAddInt(UDM_VARLIST * vars,const char * name, int val);
extern int UdmVarListAdd(UDM_VARLIST * Lst,UDM_VAR * S);

extern int UdmVarListReplaceStr(UDM_VARLIST * vars,const char * name,const char * val);
extern int UdmVarListReplaceInt(UDM_VARLIST * vars,const char * name,int val);

extern UDM_VAR *UdmVarListFind(UDM_VARLIST * vars,const char * name);
extern UDM_VAR *UdmVarListFindWithValue(UDM_VARLIST * vars,const char * name,const char * val);

extern const char * UdmVarListFindStr(UDM_VARLIST * vars,const char * name,const char * defval);
extern int          UdmVarListFindInt(UDM_VARLIST * vars,const char * name,int defval);


#endif
